/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.base;

import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSTModel;
import filenet.ws.api.uddi.WSUDDIRegistry;
import java.util.Vector;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contacts;

public class VWUDDIBusinessItem {
    private WSBusinessEntity m_wsBusinessEntity = null;
    private boolean m_bModified = false;
    private boolean m_bNewBusiness = false;
    private boolean m_bValid = true;
    private Exception m_ex = null;
    private String m_msg = null;

    public VWUDDIBusinessItem(WSBusinessEntity wsBusinessEntity) {
        this.m_wsBusinessEntity = wsBusinessEntity;
    }

    public VWUDDIBusinessItem(WSUDDIRegistry uddiRegistry, String businessKey) throws Exception {
        this.m_wsBusinessEntity = new WSBusinessEntity(uddiRegistry, businessKey);
    }

    public VWUDDIBusinessItem(WSUDDIRegistry uddiRegistry, BusinessEntity uddiBusinessEntity) throws Exception {
        this.m_wsBusinessEntity = new WSBusinessEntity(uddiRegistry, uddiBusinessEntity);
    }

    public WSBusinessEntity getWSBusinessEntity() {
        return this.m_wsBusinessEntity;
    }

    public WSUDDIRegistry getWSUDDIRegistry() {
        return this.m_wsBusinessEntity.getWSUDDIRegistry();
    }

    public boolean hasBusinessKey() throws Exception {
        return this.m_wsBusinessEntity.hasBusinessKey();
    }

    public void refresh() throws Exception {
        this.m_wsBusinessEntity.refresh();
        this.m_bModified = false;
    }

    public BusinessEntity getBusinessEntity() throws Exception {
        return this.m_wsBusinessEntity.getBusinessEntity();
    }

    public Name getName(int index) {
        return this.m_wsBusinessEntity.getName(index);
    }

    public String getNameString(int index) {
        if (this.m_wsBusinessEntity.getName(index) != null) {
            return this.m_wsBusinessEntity.getName(index).getValue();
        }
        return null;
    }

    public Vector getNameVector() {
        return this.m_wsBusinessEntity.getNameVector();
    }

    public void setNameVector(Vector names) {
        this.m_wsBusinessEntity.setNameVector(names);
    }

    public String toString() {
        if (this.m_wsBusinessEntity != null && this.m_wsBusinessEntity.getName(0) != null) {
            return this.m_wsBusinessEntity.getName(0).getValue();
        }
        return null;
    }

    public String getDescription() {
        return this.m_wsBusinessEntity.getDescription();
    }

    public Vector getDescriptionVector() {
        return this.m_wsBusinessEntity.getDescriptionVector();
    }

    public void setDescriptionVector(Vector descriptions) {
        this.m_wsBusinessEntity.setDescriptionVector(descriptions);
    }

    public String getAuthorizedName() throws Exception {
        return this.m_wsBusinessEntity.getAuthorizedName();
    }

    public String getBusinessKey() throws Exception {
        return this.m_wsBusinessEntity.getBusinessKey();
    }

    public Vector getDiscoveryURLs() throws Exception {
        return this.m_wsBusinessEntity.getDiscoveryURLs();
    }

    public Contacts getContacts() throws Exception {
        return this.m_wsBusinessEntity.getContacts();
    }

    public void setContacts(Contacts contacts) throws Exception {
        this.m_wsBusinessEntity.setContacts(contacts);
    }

    public Vector getContactVector() throws Exception {
        return this.m_wsBusinessEntity.getContactVector();
    }

    public Vector getIdentifiers() throws Exception {
        return this.m_wsBusinessEntity.getIdentifiers();
    }

    public Vector getCategories() throws Exception {
        return this.m_wsBusinessEntity.getCategories();
    }

    public Vector getBusinessServices() throws Exception {
        return this.m_wsBusinessEntity.getBusinessServices();
    }

    public Vector refreshBusinessServices() throws Exception {
        Vector services = this.m_wsBusinessEntity.refreshBusinessServices();
        this.m_bModified = false;
        return services;
    }

    public Vector findServiceByName(String name) throws Exception {
        return this.m_wsBusinessEntity.findServiceByName(name);
    }

    public Vector getTModelKeys() throws Exception {
        return this.m_wsBusinessEntity.getTModelKeys();
    }

    public WSTModel[] getTModels() throws Exception {
        return this.m_wsBusinessEntity.getTModels();
    }

    public boolean isModified() {
        return this.m_bModified;
    }

    public void setModified(boolean bModified) {
        this.m_bModified = bModified;
    }

    public boolean isValid() {
        return this.m_bValid;
    }

    public void setValid(boolean bValid) {
        this.m_bValid = bValid;
    }

    public boolean isNewBusiness() {
        return this.m_bNewBusiness;
    }

    public void setNewBusiness(boolean bNewBusiness) {
        this.m_bNewBusiness = bNewBusiness;
    }
}

